USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF (SELECT OBJECT_ID('App.NVCC_usp_GetPatientBySid')) IS NOT NULL 
DROP PROCEDURE App.NVCC_usp_GetPatientBySid
GO

CREATE PROCEDURE [App].[NVCC_usp_GetPatientBySid]
	@pid int   --PatientSID

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jon Duckart (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetPatientBySid
--Server                : DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 04-14-2016
--
--Last Changed          : 06-22-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Formatting and idempotence and signing
--
--Purpose               : To retrieve a single patient record for the NVCC app by SID.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT  [PatientSID]
      ,[PatientIEN]
      ,[Sta3n] as Station
      ,[PatientName]
      ,[PatientLastName]
      ,[PatientFirstName]
      ,[PatientSSN]
      ,[ScrSSN]
      ,[StreetAddress1]
      ,[StreetAddress2]
      ,[StreetAddress3]
      ,[City]
      ,[Zip]
      ,[Zip4]
      ,[PostalCode]
      ,[Province]
      ,[CountrySID]
      ,[Country]
      ,[PhoneResidence]
      ,[PhoneWork]
      ,[PhoneCellular]
      ,[MothersMaidenName]
      ,[DateOfDeath]
      ,[DateOfDeathText]
      ,[EmailAddress]
      ,[BadAddressIndicator]
      ,[ExcludeFromFacilityDirectoryFlag]
      ,[AddressChangeInstitutionSID]
      ,[AddressChangeStaffSID]
      ,[NOKPrimaryChangeDateTime]
      ,[NOKPrimaryChangeVistaErrorDate]
      ,[NOKPrimaryChangeDateTimeTransformSID]
      ,[NOKSecondaryChangeDateTime]
      ,[NOKSecondaryChangeVistaErrorDate]
      ,[NOKSecondaryChangeDateTimeTransformSID]
      ,[NOKRelationshipToPatient]
      ,[NOKDesigneeSameAsFlag]
      ,[NOKEmergencyContactSameAsFlag]
      ,[TemporaryAddressActiveFlag]
      ,[TemporaryAddressLastEditedDateTime]
      ,[TemporaryAddressLastEditedVistaErrorDate]
      ,[TemporaryAddressLastEditedDateTimeTransformSID]
      ,[TemporaryAddressChangeInstitutionSID]
      ,[TemporaryAddressStartDate]
      ,[TemporaryAddressStartVistaErrorDate]
      ,[TemporaryAddressStartDateTransformSID]
      ,[TemporaryAddressEndDate]
      ,[TemporaryAddressEndVistaErrorDate]
      ,[TemporaryAddressEndDateTransformSID]
      ,[ConfidentialAddressActiveFlag]
      ,[CDFlag]
      ,[CDDecidedByName]
      ,[CDDecisionDate]
      ,[CDDecisionVistaErrorDate]
      ,[CDDecisionDateTransformSID]
      ,[CDReviewedDate]
      ,[CDReviewedVistaErrorDate]
      ,[CDReviewedDateTransformSID]
      ,[CDDeterminingInstitutionSID]
      ,[CDDeterminationType]
      ,[CurrentPurpleHeartDecisionType]
      ,[CurrentPurpleHeartStatus]
      ,[PurpleHeartInstitutionSID]
      ,[MedicaidNumber]
      ,[RaceSID]
      ,[Gender]
      ,[Age]
      ,[StateSID]
      ,[State]
      ,[County]
      ,[Deceased]
      ,[PatientICN]
      ,[PatientICNChecksum]
      ,[PseudoSSNFlag]
      ,[PeriodOfServiceSID]
      ,[PeriodOfService]
      ,[CurrentMeansTestStatusSID]
      ,[MaritalStatusSID]
      ,[MaritalStatus]
      ,[PercentServiceConnect]
      ,[InsuranceCoverageFlag]
      ,[ReligionSID]
      ,[Religion]
      ,[AgentOrangeExposureFlag]
      ,[AgentOrangeLocationCode]
      ,[RadiationExposureCode]
      ,[IonizingRadiationExposureFlag]
      ,[SHADFlag]
      ,[VeteranFlag]
      ,[CombatFlag]
      ,[CombatEligibilityEndDate]
      ,[CombatEligibilityEndVistaErrorDate]
      ,[CombatEligibilityEndDateTransformSID]
      ,[TestPatientFlag]
      ,[CDWPossibleTestPatientFlag]
      ,[SpinalCordInjuryType]
      ,[EnteredIntoFileDate]
      ,[EnteredIntoFileVistaErrorDate]
      ,[EnteredIntoFileDateTransformSID]
      ,[EmergencyResponseIndicator]
      ,[EligibilitySID]
      ,[Eligibility]
      ,[EligibilityVACode]
      ,[DateOfBirth]
      ,[DateOfBirthText]
      ,[SensitiveFlag]
      ,[LastServiceEntryDate]
      ,[LastServiceEntryVistaErrorDate]
      ,[LastServiceEntryDateTransformSID]
      ,[LastServiceSeparationDate]
      ,[LastServiceSeparationVistaErrorDate]
      ,[LastServiceSeparationDateTransformSID]
      ,[PreferredInstitutionSID]
      ,[POWFlag]
      ,[POWLocationSID]
      ,[POWFromVistaDate]
      ,[POWToVistaDate]
      ,[CombatFromVistaDate]
      ,[CombatToVistaDate]
      ,[ClaimNumber]
      ,[RoomBedSID]
      ,[IneligibleDate]
      ,[IneligibleVistaErrorDate]
      ,[IneligibleDateTransformSID]
      ,[IneligibleReason]
      ,[EligibilityStatus]
      ,[EligibilityVerificationSource]
      ,[GISLocatorName]
      ,[GISMatchStatusCode]
      ,[GISMatchScore]
      ,[GISMatchMethodCode]
      ,[GISMatchedAddress]
      ,[GISAddressType]
      ,[GISStreetSide]
      ,[GISPatientAddressLongitude]
      ,[GISPatientAddressLatitude]
      ,[GISAddressUpdatedDate]
      ,[GISFIPSCode]
      ,[GISMarket]
      ,[GISSubmarket]
      ,[GISSector]
      ,[GISURH]
      ,[GISCongressDistrict]
   FROM  CDWWork.SPatient.SPatient
	WHERE
		PatientSid= @pid
		AND patientname <>'*Unknown at this time*'
		AND patientname is not null;
END;
GO

EXEC sp_SignAppObject 'NVCC_usp_GetPatientBySid';
